/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.taskman.pa;

import filenet.vw.api.VWException;
import filenet.vw.api.VWFieldType;
import filenet.vw.apps.taskman.VWTaskCore;
import filenet.vw.apps.taskman.VWTaskNumericProperty;
import filenet.vw.apps.taskman.VWTaskTabPanel;
import filenet.vw.apps.taskman.pa.PADataFieldWizard;
import filenet.vw.apps.taskman.pa.PADimensionRangesListModel;
import filenet.vw.apps.taskman.pa.resources.VWResource;
import filenet.vw.apps.taskman.toolkit.dialog.IVWTaskWizardPanel;
import filenet.vw.base.VWString;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import filenet.vw.toolkit.utils.uicontrols.calendar.VWCalendarControlDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class PAConfigureDataFieldPanel
extends JPanel
implements IVWTaskWizardPanel {
    PADataFieldWizard m_wizard = null;
    VWCalendarControlDialog m_calendarDialog = null;
    DimensionalRangesPanel m_rangesPanel = null;
    JRadioButton m_dimensionRadio = null;
    JRadioButton m_measureRadio = null;
    int m_fieldType = -1;

    public PAConfigureDataFieldPanel(PADataFieldWizard wizard) {
        this.m_wizard = wizard;
        this.initLayout();
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        this.m_calendarDialog = new VWCalendarControlDialog((Frame)VWTaskCore.getInstance().getMainFrame(), 102, cal.getTime());
    }

    public boolean isMeasure() {
        return this.m_measureRadio.isSelected();
    }

    public Object[] getRanges() {
        return this.m_rangesPanel.getRanges();
    }

    public void performValidation() throws Exception {
        if (this.m_wizard.isNewDataField() && this.m_dimensionRadio.isSelected() && this.m_wizard.getFieldType() == 8 && this.m_rangesPanel.getRanges() == null) {
            throw new VWException("filenet.vw.apps.taskman.pa.PAConfigureDataFieldPanel.RangeValuesMustBeDefinedForFloatUDFDimension", "Dimension ranges must be specified for float dimensions.");
        }
    }

    public String getInstructions() {
        return VWResource.ConfigureDataField;
    }

    public String getHelpPath() {
        return VWHelp.Help_Process_TaskManager + "pa_data_fields.htm";
    }

    public void refresh() {
        this.m_measureRadio.setEnabled(this.canBeMeasure() && this.m_wizard.isNewDataField());
        this.m_dimensionRadio.setEnabled(this.m_wizard.isNewDataField());
        this.m_dimensionRadio.setSelected(this.m_dimensionRadio.isSelected() || this.m_measureRadio.isSelected() && !this.canBeMeasure());
        this.m_rangesPanel.refresh();
    }

    private boolean canBeMeasure() {
        return this.m_wizard.getFieldType() == 8 || this.m_wizard.getFieldType() == 1;
    }

    private void initLayout() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 23;
        c.fill = 1;
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.getTypePanel(), c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(20, 0, 0, 0);
        this.m_rangesPanel = new DimensionalRangesPanel();
        this.add((Component)this.m_rangesPanel, c);
    }

    private JPanel getTypePanel() {
        VWToolbarBorder borderPanel = new VWToolbarBorder(VWResource.Type, 0);
        JPanel panel = borderPanel.getClientPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 23;
        c.fill = 1;
        this.m_dimensionRadio = new JRadioButton(VWResource.Dimension, true);
        this.m_dimensionRadio.setBorder(null);
        this.m_dimensionRadio.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1 && PAConfigureDataFieldPanel.this.m_rangesPanel != null) {
                    PAConfigureDataFieldPanel.this.m_rangesPanel.clear();
                    PAConfigureDataFieldPanel.this.m_rangesPanel.refresh();
                }
            }
        });
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.weighty = 1.0;
        c.insets = new Insets(10, 10, 0, 10);
        panel.add((Component)this.m_dimensionRadio, c);
        this.m_measureRadio = new JRadioButton(VWResource.Measure, false);
        this.m_measureRadio.setBorder(null);
        this.m_measureRadio.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1 && PAConfigureDataFieldPanel.this.m_rangesPanel != null) {
                    PAConfigureDataFieldPanel.this.m_rangesPanel.clear();
                    PAConfigureDataFieldPanel.this.m_rangesPanel.refresh();
                }
            }
        });
        c.gridx = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(10, 0, 0, 10);
        panel.add((Component)this.m_measureRadio, c);
        if (!this.m_wizard.isNewDataField()) {
            this.m_dimensionRadio.setSelected(!this.m_wizard.getDataFieldNode().isMeasure());
            this.m_measureRadio.setSelected(this.m_wizard.getDataFieldNode().isMeasure());
        }
        ButtonGroup grp = new ButtonGroup();
        grp.add(this.m_dimensionRadio);
        grp.add(this.m_measureRadio);
        return borderPanel;
    }

    public boolean skipThisPanel() {
        return false;
    }

    class DimensionalRangesPanel
    extends JPanel
    implements ActionListener {
        private JLabel m_boundaryLabel = null;
        private VWTaskNumericProperty m_intBoundary = null;
        private JTextField m_floatBoundary = null;
        private JTextField m_boundary = null;
        private JButton m_addButton = null;
        private JButton m_deleteButton = null;
        private JList m_boundaryList = null;
        private PADimensionRangesListModel m_boundaryModel = null;
        private Component m_boundaryListSpacer = null;
        private int m_fieldType = -1;

        public DimensionalRangesPanel() {
            this.initLayout();
            this.refresh();
            if (!PAConfigureDataFieldPanel.this.m_wizard.isNewDataField()) {
                this.setRanges(PAConfigureDataFieldPanel.this.m_wizard.getDataFieldNode().getRanges());
            }
        }

        public void refresh() {
            if (PAConfigureDataFieldPanel.this.m_wizard.getFieldType() != this.m_fieldType) {
                this.m_boundaryModel.clear();
                this.m_fieldType = PAConfigureDataFieldPanel.this.m_wizard.getFieldType();
                if (this.m_fieldType == 1) {
                    this.m_floatBoundary.setVisible(false);
                    this.m_intBoundary.setVisible(true);
                    this.m_intBoundary.setText("");
                    this.m_boundary = this.m_intBoundary;
                } else if (this.m_fieldType == 8) {
                    this.m_intBoundary.setVisible(false);
                    this.m_floatBoundary.setVisible(true);
                    this.m_floatBoundary.setText("");
                    this.m_boundary = this.m_floatBoundary;
                } else {
                    this.m_intBoundary.setVisible(false);
                    this.m_floatBoundary.setVisible(false);
                }
            }
            boolean enabled = this.canHaveRanges() && PAConfigureDataFieldPanel.this.m_wizard.isNewDataField();
            this.m_deleteButton.setEnabled(enabled && this.m_boundaryList.getSelectedValues().length > 0);
            this.m_boundary.setEditable(enabled);
            this.m_boundaryLabel.setEnabled(enabled);
            this.m_boundaryLabel.setVisible(this.m_fieldType != 16);
            this.m_boundary.setVisible(this.m_fieldType != 16);
            this.m_boundaryListSpacer.setVisible(this.m_fieldType != 16);
            if (this.m_boundary.isVisible()) {
                this.m_addButton.setEnabled(enabled && !this.m_boundary.getText().trim().equals(""));
            } else {
                this.m_addButton.setEnabled(enabled);
            }
            if (enabled) {
                this.m_boundaryList.setBackground(new JList().getBackground());
            } else {
                this.m_boundaryList.setBackground(this.getBackground());
            }
        }

        public void clear() {
            this.m_intBoundary.setText("");
            this.m_floatBoundary.setText("");
            this.m_boundaryModel.clear();
        }

        public Object[] getRanges() {
            Object[] ranges = this.m_boundaryModel.toArray();
            return ranges != null && ranges.length > 0 ? ranges : null;
        }

        public void actionPerformed(ActionEvent e) {
            try {
                Object source = e.getSource();
                if (source == this.m_addButton || source == this.m_boundary) {
                    if (this.m_fieldType == 16) {
                        PAConfigureDataFieldPanel.this.m_calendarDialog.setVisible(true);
                        Date date = PAConfigureDataFieldPanel.this.m_calendarDialog.getDate();
                        if (date != null) {
                            this.addBoundary(date);
                        }
                    } else {
                        this.addBoundary(this.m_boundary.getText());
                    }
                } else if (source == this.m_deleteButton) {
                    int index = this.m_boundaryList.getSelectedIndex();
                    while (index != -1) {
                        this.m_boundaryModel.remove(index);
                        index = this.m_boundaryList.getSelectedIndex();
                    }
                }
                this.refresh();
            }
            catch (Exception ex) {
                VWTaskCore.getInstance().displayError(ex);
            }
        }

        private void setRanges(Object[] ranges) {
            this.m_boundaryModel.clear();
            if (ranges != null) {
                for (int i = 0; i < ranges.length; ++i) {
                    this.m_boundaryModel.add(ranges[i]);
                }
            }
        }

        private boolean canHaveRanges() {
            int fieldType = this.m_fieldType;
            return (fieldType == 8 || fieldType == 1 || fieldType == 16) && !PAConfigureDataFieldPanel.this.isMeasure();
        }

        private void initLayout() {
            VWToolbarBorder borderPanel = new VWToolbarBorder(VWResource.DimensionRanges, 0);
            JPanel clientPanel = borderPanel.getClientPanel();
            clientPanel.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 23;
            c.fill = 1;
            c.gridy = 0;
            ++c.gridx;
            c.insets = new Insets(10, 0, 50, 0);
            c.weightx = 1.0;
            c.weighty = 1.0;
            clientPanel.add((Component)this.getWestPanel(), c);
            ++c.gridx;
            c.insets = new Insets(0, 0, 0, 0);
            c.weightx = 0.0;
            c.weighty = 1.0;
            clientPanel.add((Component)this.getEastPanel(), c);
            this.setLayout(new BorderLayout());
            this.add((Component)borderPanel, "Center");
        }

        private VWTaskTabPanel getWestPanel() {
            VWTaskTabPanel panel = new VWTaskTabPanel();
            panel.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 23;
            c.fill = 2;
            c.gridx = 0;
            ++c.gridy;
            c.insets = new Insets(0, 10, 0, 0);
            c.weightx = 0.0;
            c.weighty = 0.0;
            this.m_boundaryLabel = new JLabel(VWResource.Label.toString(VWResource.Boundary));
            panel.add((Component)this.m_boundaryLabel, c);
            c.gridx = 1;
            c.weightx = 1.0;
            c.weighty = 0.0;
            c.insets = new Insets(0, 10, 0, 0);
            this.m_floatBoundary = new JTextField();
            this.m_floatBoundary.setVisible(false);
            this.m_floatBoundary.addActionListener(this);
            this.m_floatBoundary.addKeyListener(new KeyListener(){

                public void keyReleased(KeyEvent evt) {
                    DimensionalRangesPanel.this.refresh();
                }

                public void keyPressed(KeyEvent evt) {
                }

                public void keyTyped(KeyEvent evt) {
                }
            });
            panel.add((Component)this.m_floatBoundary, c);
            this.m_intBoundary = new VWTaskNumericProperty("", "##########");
            this.m_intBoundary.addActionListener(this);
            this.m_intBoundary.addKeyListener(new KeyListener(){

                public void keyReleased(KeyEvent evt) {
                    DimensionalRangesPanel.this.refresh();
                }

                public void keyPressed(KeyEvent evt) {
                }

                public void keyTyped(KeyEvent evt) {
                }
            });
            panel.add((Component)this.m_intBoundary, c);
            this.m_boundary = this.m_intBoundary;
            c.gridx = 0;
            ++c.gridy;
            c.gridwidth = 2;
            c.weightx = 1.0;
            c.weighty = 0.0;
            c.insets = new Insets(5, 0, 0, 0);
            this.m_boundaryListSpacer = Box.createHorizontalStrut(0);
            panel.add(this.m_boundaryListSpacer, c);
            c.gridx = 0;
            ++c.gridy;
            c.gridwidth = 2;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.insets = new Insets(0, 10, 0, 0);
            c.fill = 1;
            this.m_boundaryModel = new PADimensionRangesListModel();
            this.m_boundaryList = new JList(this.m_boundaryModel);
            this.m_boundaryList.setVisibleRowCount(6);
            this.m_boundaryList.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent e) {
                    DimensionalRangesPanel.this.refresh();
                }
            });
            panel.add((Component)new JScrollPane(this.m_boundaryList), c);
            return panel;
        }

        private VWTaskTabPanel getEastPanel() {
            VWTaskTabPanel panel = new VWTaskTabPanel();
            panel.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 23;
            c.fill = 2;
            c.gridx = 0;
            ++c.gridy;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.gridwidth = 1;
            c.insets = new Insets(10, 5, 0, 0);
            this.m_addButton = new JButton(VWResource.Add);
            this.m_addButton.addActionListener(this);
            panel.add((Component)this.m_addButton, c);
            c.gridx = 1;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.gridwidth = 1;
            c.insets = new Insets(0, 0, 0, 0);
            panel.add(Box.createHorizontalStrut(100), c);
            c.gridx = 0;
            ++c.gridy;
            c.weightx = 0.0;
            c.weighty = 1.0;
            c.gridwidth = 1;
            c.insets.top = 5;
            c.insets = new Insets(2, 5, 0, 0);
            this.m_deleteButton = new JButton(VWResource.Delete);
            this.m_deleteButton.addActionListener(this);
            panel.add((Component)this.m_deleteButton, c);
            return panel;
        }

        private void addBoundary(Object value) throws VWException {
            if (value == null) {
                return;
            }
            try {
                Object obj = value;
                switch (this.m_fieldType) {
                    case 8: {
                        if (!(value instanceof String)) break;
                        obj = Double.valueOf((String)value);
                        break;
                    }
                    case 1: {
                        if (!(value instanceof String)) break;
                        obj = Integer.valueOf((String)value);
                        break;
                    }
                    case 16: {
                        obj = value;
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unable to add boundary - current field type is invalid: " + this.m_fieldType);
                    }
                }
                this.m_boundaryModel.add(obj);
                this.m_boundary.setText("");
            }
            catch (NumberFormatException ex) {
                if (this.m_fieldType == 1) {
                    try {
                        if (Long.parseLong((String)value) > Integer.MAX_VALUE) {
                            VWString msg = new VWString("filenet.vw.apps.taskman.pa.PAConfigureDataFieldPanel.ValueExceedsMaxSizeForInt", "The maximum value for an integer boundary is {0}.", new Integer(Integer.MAX_VALUE));
                            VWTaskCore.getInstance().displayError(msg.toString(), false);
                            this.m_boundary.requestFocus();
                            return;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                VWTaskCore.getInstance().displayError(VWResource.InvalidFormat.toString(VWFieldType.getLocalizedString(this.m_fieldType)), false);
            }
            this.m_boundary.requestFocus();
        }
    }
}

